;;  Programm:      ACM-SLOESCHEN.LSP
;;  Befehlsaufruf: ACM-SLOESCHEN
;;  Funktion:      Lscht Objekte ohne Auswahlbesttigung.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         14.06.2024
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-sloeschen ( / slo40 slo41 slo42 sol01 sol02 sol03 sol04 sol05 sol06 sol07 sol08 sol09 sol10 sol11 sol12)
    (defun sol01 (slo01 / )
        (if slo41 (setq *error* slo41))
        (if slo12
          (vl-catch-all-apply 'setvar (list "CMDECHO" slo12))
        )
        (if slo10
          (vl-catch-all-apply 'setvar (list "PICKBOX" slo10))
        )
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun sol02 ( / slo08)
      (setq slo08 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= slo08 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq slo09 T)
            (setq slo09 nil)
        )
        (if (not slo09)
          (alert "\042acm-sloeschen\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      slo09
    )
    (defun sol03 (slo02 / slo10 slo11)
      (sssetfirst nil nil)
      (setq slo10 (getvar "PICKBOX"))
      (initget "Einstellungen Beenden")
      (setq slo11 (getkword "\nObjektwahl mit EINGABETASTE starten oder [Einstellungen/Beenden]: "))
        (while (= slo11 "Einstellungen")
          (sol09 slo10)
          (initget "Einstellungen Beenden")
          (setq slo11 (getkword "\nObjektwahl mit EINGABETASTE starten oder [Einstellungen/Beenden]: "))
        )
        (if (/= slo11 "Beenden")
          (progn
              (if (= eteledkciuqmca220231120 1)
                (setvar "PICKBOX" eteledkciuqmca320231120)
              )
            (sol04 eteledkciuqmca420231120 eteledkciuqmca520231120 slo02)
              (if slo10
                (setvar "PICKBOX" slo10)
              )
          )
        )
    )
    (defun sol04 (slo03 slo04 slo05 / slo12 slo13 slo14)
      (setq slo12 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq slo13 (getvar "ERRNO"))
      (setvar "ERRNO" 0)
        (if (> slo04 0)
          (progn
            (while (vl-position (getvar "ERRNO") (list 0))
              (setq slo14 (ssget "_:S"))
                (if slo14
                  (if (= slo03 0)
                    (sol12 slo14)
                    (sol07 slo14 slo05)
                  )
                )
            )
          )
          (progn
            (while (vl-position (getvar "ERRNO") (list 0))
              (setq slo14 (ssget "_:S"))
                (if slo14
                  (progn
                      (if (= slo03 0)
                        (sol12 slo14)
                        (sol07 slo14 slo05)
                      )
                    (setvar "ERRNO" 1)
                  )
                )
            )
          )
        )
      (setvar "ERRNO" slo13)
      (setvar "CMDECHO" slo12)
    )
    (defun sol05 ( / slo15 slo16 slo27)
      (if
        (and
          slo42
          (= eteledkciuqmca420231120 1)
        )
          (progn
            (if (> eteledkciuqmca120231120 0)
              (prompt "\nACHTUNG: Aktuell werden auch gesperrte Objekte gelscht. ")
              (progn
                (if (setq slo15 (sol06))
                  (progn
                    (setq slo16 (load_dialog slo15))
                      (if (not (new_dialog "acm_alert" slo16))
                        (exit)
                      )
                    (vl-catch-all-apply 'vl-file-delete (list slo15))
                    (action_tile "b_01" "(setq eteledkciuqmca120231120 (atoi (get_tile \"tg_01\"))) (done_dialog)")
                    (start_dialog)
                    (unload_dialog slo16)
                  )
                )
              )
            )
          )
      )
    )
    (defun sol06 ( / slo20 slo18 slo19)
      (if
        (and
          (setq slo18 (vl-filename-mktemp "acm.dcl"))
          (setq slo19 (open slo18 "w"))
        )
          (progn
            (setq slo20
              (list
                "acm_alert"
                ":dialog{label=\042ACHTUNG\042;"
                ":spacer{height=0.2;}"
                ":text{value=\042Aktuell werden auch gesperrte\042;}"
                ":text{value=\042Objekte gelscht.\042;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=0;}"
                ":column{width=10;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}}"
                ":spacer{width=0;}}"
                ":toggle{key=\042tg_01\042;label=\042&Nicht mehr anzeigen\042;}}"
              )
            )
              (while slo20
                (write-line (car slo20) slo19)
                (setq slo20 (cdr slo20))
              )
            (setq slo19 (close slo19))
            slo18
          )
          nil
      )
    )
    (defun sol07 (slo06 slo05 / slo21 slo22 slo23 slo24)
      (setq slo21 slo05)
        (while slo21
          (setq slo22 (car slo21))
          (setq slo23 (vlax-ename->vla-object (tblobjname "LAYER" slo22)))
          (vla-put-Lock slo23 :vlax-false)
          (setq slo24 (cons slo23 slo24))
          (setq slo21 (cdr slo21))
        )
      (sol12 slo06)
        (while slo24
          (setq slo22 (car slo24))
          (vla-put-Lock slo22 :vlax-true)
          (setq slo24 (cdr slo24))
        )
    )
    (defun sol08 ( / slo25 slo43 slo26 slo21)
      (setq slo25 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
        (vlax-for slo43 slo25
          (if
            (and
              (not (vl-string-search "|" (setq slo26 (strcase (vla-get-Name slo43)))))
              (= (vla-get-Lock slo43) :vlax-true)
            )
              (setq slo21 (cons slo26 slo21))
          )
        )
      slo21
    )
    (defun sol09 (slo07 / slo15 slo16 slo27 slo30)
        (if (setq slo15 (sol10))
          (progn
            (setq slo16 (load_dialog slo15))
              (if (not (new_dialog "acm_sbe" slo16))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list slo15))
            (start_list "pl_01")
            (mapcar 'add_list (list (strcat "Akt. (" (itoa (getvar "PICKBOX")) ")") "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20"))
            (end_list)
            (set_tile "tg_01" (itoa eteledkciuqmca420231120))
            (set_tile "tg_02" (itoa eteledkciuqmca520231120))
              (if (= eteledkciuqmca220231120 0)
                (set_tile "pl_01" "0")
                (set_tile "pl_01" (itoa eteledkciuqmca320231120))
              )
              (action_tile "b_01" "(setq slo27 (atoi (get_tile \"pl_01\")))
                  (if (= slo27 0)
                    (progn
                      (setq eteledkciuqmca220231120 0)
                      (setq eteledkciuqmca320231120 (getvar \"PICKBOX\"))
                    )
                    (progn
                      (setq eteledkciuqmca220231120 1)
                      (setq eteledkciuqmca320231120 slo27)
                    )
                  )
                (setq slo30 (list (setq eteledkciuqmca420231120 (atoi (get_tile \"tg_01\"))) (setq eteledkciuqmca520231120 (atoi (get_tile \"tg_02\"))) eteledkciuqmca220231120 eteledkciuqmca320231120))
                (done_dialog)
                (sol11 slo07)"
              )
            (action_tile "b_02" "(setq slo30 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog slo16)
          )
        )
      slo30
    )
    (defun sol10 ( / slo20 slo18 slo19)
      (if
        (and
          (setq slo18 (vl-filename-mktemp "acm.dcl"))
          (setq slo19 (open slo18 "w"))
        )
          (progn
              (setq slo20
                (list
                  "acm_sbe"
                  ":dialog{label=\042Einstellungen\042;"
                  ":spacer{height=0.2;}"
                  ":popup_list{key=\042pl_01\042;label=\042&Pickbox-Gre:\042;edit_width=8;}"
                  ":spacer{height=0.6;}"
                  ":toggle{key=\042tg_01\042;label=\042&Layersperrung ignorieren\042;}"
                  ":toggle{key=\042tg_02\042;label=\042&Wiederholmodus ein\042;}"
                  ":spacer{height=0.3;}"
                  ":row{"
                  ":spacer{width=0;}"
                  ":column{width=0;fixed_width=true;"
                  ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                  ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                  ":spacer{width=0;}}}"
                )
              )
              (while slo20
                (write-line (car slo20) slo19)
                (setq slo20 (cdr slo20))
              )
            (setq slo19 (close slo19))
            slo18
          )
          nil
      )
    )
    (defun sol11 (slo07 / slo33 slo34 slo35)
        (if (not (vl-position eteledkciuqmca220231120 (list 0 1)))
          (setq eteledkciuqmca220231120 0)
        )
        (if (not (vl-position eteledkciuqmca320231120 (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
          (progn
            (setq eteledkciuqmca220231120 0)
            (setq eteledkciuqmca320231120 (getvar "PICKBOX"))
          )
        )
        (if (not (vl-position eteledkciuqmca420231120 (list 0 1)))
          (setq eteledkciuqmca420231120 0)
        )
        (if (not (vl-position eteledkciuqmca520231120 (list 0 1)))
          (setq eteledkciuqmca520231120 1)
        )
        (if (not (vl-position eteledkciuqmca120231120 (list 0 1)))
          (setq eteledkciuqmca120231120 0)
        )
        (if (= eteledkciuqmca220231120 0)
          (setq slo33 (strcat "\nAkt. Einstellungen: Pickbox-Gre = Aktuell (" (itoa slo07) "),"))
          (setq slo33 (strcat "\nAkt. Einstellungen: Pickbox-Gre = Befehlsabhngig (" (itoa eteledkciuqmca320231120) "),"))
        )
      (setq slo34 (strcat " Layersperrung ignorieren = " (nth eteledkciuqmca420231120 (list "Nein," "Ja,"))))
      (setq slo35 (strcat " Wiederholmodus ein = " (nth eteledkciuqmca520231120 (list "Nein" "Ja")) " "))
      (prompt (strcat slo33 slo34 slo35))
    )
      (defun sol12 (slo06 / slo36 slo37 slo38 slo39)
        (if (<= (setq slo36 (sslength slo06)) 500)
          (progn
            (setq slo37 -1)
              (repeat slo36
                (setq slo37 (1+ slo37))
                (setq slo38 (ssname slo06 slo37))
                (setq slo39 (vlax-ename->vla-object slo38))
                (vl-catch-all-apply 'vla-Delete (list slo39))
              )
          )
          (vl-cmdf "._erase" slo06 "")
        )
      )
  (if (sol02)
    (progn
      (vl-load-com)
      (setq slo40 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq slo41 *error*)
      (setq *error* sol01)
      (vla-EndUndoMark slo40)
      (vla-StartUndoMark slo40)
      (sol11 (getvar "PICKBOX"))
      (setq slo42 (sol08))
      (sol05)
      (sol03 slo42)
        (if slo41
          (setq *error* slo41)
          (setq *error* nil)
        )
      (vla-EndUndoMark slo40)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-SLOESCHEN (Copyright  2024 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-SLOESCHEN auf.")
